package com.tomas.ht_ydt.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_ydt.ClickItem_Rework;
import com.tomas.ht_ydt.ListData.Rework_List;
import com.tomas.ht_ydt.R;

import java.text.DecimalFormat;
import java.util.List;

public class Rework_Adapter extends RecyclerView.Adapter<Rework_Adapter.ViewHolder> {
    List<Rework_List> data;
    Context context;
    DecimalFormat decimalFormat;
    private ClickItem_Rework onClickItem;

    public Rework_Adapter(List<Rework_List> data, Context context, ClickItem_Rework onClickItem) {
        this.data = data;
        this.context = context;
        this.onClickItem = onClickItem;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_no, txt_part_no, txt_lot_no, txt_qty, txt_unit;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout) itemView.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_part_no = (TextView)itemView.findViewById(R.id.txt_part_no);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_unit = (TextView)itemView.findViewById(R.id.txt_unit);

        }
    }

    @NonNull
    @Override
    public Rework_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_rework,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,##0.00");
        final Rework_List item = data.get(position);
        holder.txt_no.setText(item.getNo());
        holder.txt_part_no.setText(item.getPart_no());
        holder.txt_lot_no.setText(item.getLot_no());
//        holder.txt_qty.setText(decimalFormat.format(Float.parseFloat(item.getQty())));
        holder.txt_qty.setText(item.getQty());
        holder.txt_unit.setText(item.getUnit());

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickItem.Item_Rework(
                        item.getId(),
                        item.getPart_no(),
                        item.getQty(),
                        item.getUnit(),
                        item.getLot_no()
                );
            }
        });
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
